Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Class Region

    Private proTable As DataTable

    Private proRowCount As System.Int32

    Private proRowIndex As System.Int32

    Private proDBReturn As System.Int32

    Private DBPersistant As System.Boolean

    Private objDataReader As SqlDataReader

    Friend ReadOnly Property Table() As DataTable
        Get
            Return proTable
        End Get
    End Property

    Friend ReadOnly Property Row() As DataRow
        Get
            Return proTable.Rows(proRowIndex)
        End Get
    End Property

    Friend ReadOnly Property XML() As System.String
        Get
            Return Database.XML(proTable)
        End Get
    End Property

    Friend ReadOnly Property RowCount() As System.Int32
        Get
            Return proRowCount
        End Get
    End Property

    Friend ReadOnly Property RowIndex() As System.Int32
        Get
            Return proRowIndex
        End Get
    End Property

    Friend ReadOnly Property DBReturn() As System.Int32
        Get
            Return proDBReturn
        End Get
    End Property

    Friend ReadOnly Property DTNew() As System.DateTime
        Get
            Return Database.DTNew()
        End Get
    End Property

    Friend ReadOnly Property DTNow() As System.DateTime
        Get
            Return Database.DTNow()
        End Get
    End Property

    Friend Property RegionID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("RegionID")), Database.Null4(), proTable.Rows(proRowIndex)("RegionID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("RegionID") = value
        End Set
    End Property

    Friend Property RegionCode() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("RegionCode")), Database.NullS(), proTable.Rows(proRowIndex)("RegionCode")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("RegionCode") = value
        End Set
    End Property

    Friend Property RegionName() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("RegionName")), Database.NullS(), proTable.Rows(proRowIndex)("RegionName")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("RegionName") = value
        End Set
    End Property

    Friend Property Representative() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("Representative")), Database.NullS(), proTable.Rows(proRowIndex)("Representative")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("Representative") = value
        End Set
    End Property

    Friend Sub New(ByVal Persistence As System.Boolean)

        DBPersistant = Persistence

        proTable = New DataTable

        proTable.TableName = "Region"

        proTable.Columns.Add("RegionID", GetType(System.Int32))
        proTable.Columns.Add("RegionCode", GetType(System.String))
        proTable.Columns.Add("RegionName", GetType(System.String))
        proTable.Columns.Add("Representative", GetType(System.String))

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear()

        proTable.Rows.Clear()

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear(ByVal Z As System.Int32)

        proTable.Rows.Clear()

        For I As System.Int32 = 1 To Z

            proTable.Rows.Add(proTable.NewRow)

        Next

        proRowCount = Z

        proRowIndex = 0

    End Sub

    Friend Sub Move()

        Me.Move(proRowIndex + 1)

    End Sub

    Friend Sub Move(ByVal MyRow As System.Int32)

        Dim I As System.Int32 = proRowCount - 1

        If MyRow < 0 Then Throw New System.InvalidOperationException("Row Index < 0")

        If MyRow > I Then Throw New System.InvalidOperationException("Row Index > N")

        proRowIndex = MyRow

    End Sub

    Friend Sub ResetColumn(ByVal MyColumn As System.String)

        proTable.Rows(proRowIndex)(MyColumn) = System.DBNull.Value

    End Sub

    Friend Sub GetRow(ByVal RegionID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@RegionID", SqlDbType.Int).Value = RegionID
            Database.objCommand.Parameters("@RegionID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSRegion"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount = 1 Then proRowIndex = 0

            If proRowCount < 1 Then Throw New System.InvalidOperationException("Row Count < 1")

            If proRowCount > 1 Then Throw New System.InvalidOperationException("Row Count > 1")

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Region / GetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRow()

        Me.CutRow(Me.RegionID)

    End Sub

    Friend Sub CutRow(ByVal RegionID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@RegionID", SqlDbType.Int).Value = RegionID
            Database.objCommand.Parameters("@RegionID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDRegion"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Region / CutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub SetRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@RegionID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("RegionID")
            Database.objCommand.Parameters("@RegionID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@RegionCode", SqlDbType.Char).Value = proTable.Rows(proRowIndex)("RegionCode")
            Database.objCommand.Parameters("@RegionCode").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@RegionName", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("RegionName")
            Database.objCommand.Parameters("@RegionName").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Representative", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Representative")
            Database.objCommand.Parameters("@Representative").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGURegion"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Region / SetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub PutRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@RegionCode", SqlDbType.Char).Value = proTable.Rows(proRowIndex)("RegionCode")
            Database.objCommand.Parameters("@RegionCode").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@RegionName", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("RegionName")
            Database.objCommand.Parameters("@RegionName").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Representative", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Representative")
            Database.objCommand.Parameters("@Representative").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RegionID", SqlDbType.Int)
            Database.objCommand.Parameters("@RegionID").Direction = ParameterDirection.Output

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGIRegion"

            Database.objCommand.ExecuteNonQuery

            Me.RegionID = CType(Database.objCommand.Parameters("@RegionID").Value, System.Int32)

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Region / PutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

End Class
