Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Class Purchase

    Private proTable As DataTable

    Private proRowCount As System.Int32

    Private proRowIndex As System.Int32

    Private proDBReturn As System.Int32

    Private DBPersistant As System.Boolean

    Private objDataReader As SqlDataReader

    Friend ReadOnly Property Table() As DataTable
        Get
            Return proTable
        End Get
    End Property

    Friend ReadOnly Property Row() As DataRow
        Get
            Return proTable.Rows(proRowIndex)
        End Get
    End Property

    Friend ReadOnly Property XML() As System.String
        Get
            Return Database.XML(proTable)
        End Get
    End Property

    Friend ReadOnly Property RowCount() As System.Int32
        Get
            Return proRowCount
        End Get
    End Property

    Friend ReadOnly Property RowIndex() As System.Int32
        Get
            Return proRowIndex
        End Get
    End Property

    Friend ReadOnly Property DBReturn() As System.Int32
        Get
            Return proDBReturn
        End Get
    End Property

    Friend ReadOnly Property DTNew() As System.DateTime
        Get
            Return Database.DTNew()
        End Get
    End Property

    Friend ReadOnly Property DTNow() As System.DateTime
        Get
            Return Database.DTNow()
        End Get
    End Property

    Friend Property PurchaseID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("PurchaseID")), Database.Null4(), proTable.Rows(proRowIndex)("PurchaseID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("PurchaseID") = value
        End Set
    End Property

    Friend Property CustomerID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("CustomerID")), Database.Null4(), proTable.Rows(proRowIndex)("CustomerID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("CustomerID") = value
        End Set
    End Property

    Friend Property OrderNumber() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("OrderNumber")), Database.Null4(), proTable.Rows(proRowIndex)("OrderNumber")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("OrderNumber") = value
        End Set
    End Property

    Friend Property OrderDate() As System.DateTime
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("OrderDate")), Database.DTNew(), proTable.Rows(proRowIndex)("OrderDate")), System.DateTime)
        End Get
        Set(ByVal value As System.DateTime)
            proTable.Rows(proRowIndex)("OrderDate") = value
        End Set
    End Property

    Friend Sub New(ByVal Persistence As System.Boolean)

        DBPersistant = Persistence

        proTable = New DataTable

        proTable.TableName = "Purchase"

        proTable.Columns.Add("PurchaseID", GetType(System.Int32))
        proTable.Columns.Add("CustomerID", GetType(System.Int32))
        proTable.Columns.Add("OrderNumber", GetType(System.Int32))
        proTable.Columns.Add("OrderDate", GetType(System.DateTime))

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear()

        proTable.Rows.Clear()

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear(ByVal Z As System.Int32)

        proTable.Rows.Clear()

        For I As System.Int32 = 1 To Z

            proTable.Rows.Add(proTable.NewRow)

        Next

        proRowCount = Z

        proRowIndex = 0

    End Sub

    Friend Sub Move()

        Me.Move(proRowIndex + 1)

    End Sub

    Friend Sub Move(ByVal MyRow As System.Int32)

        Dim I As System.Int32 = proRowCount - 1

        If MyRow < 0 Then Throw New System.InvalidOperationException("Row Index < 0")

        If MyRow > I Then Throw New System.InvalidOperationException("Row Index > N")

        proRowIndex = MyRow

    End Sub

    Friend Sub ResetColumn(ByVal MyColumn As System.String)

        proTable.Rows(proRowIndex)(MyColumn) = System.DBNull.Value

    End Sub

    Friend Sub GetRow(ByVal PurchaseID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = PurchaseID
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPurchase"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount = 1 Then proRowIndex = 0

            If proRowCount < 1 Then Throw New System.InvalidOperationException("Row Count < 1")

            If proRowCount > 1 Then Throw New System.InvalidOperationException("Row Count > 1")

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Purchase / GetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub GetRowsByCustomer()

        Me.GetRowsByCustomer(Me.CustomerID)

    End Sub

    Friend Sub GetRowsByCustomer(ByVal CustomerID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@CustomerID", SqlDbType.Int).Value = CustomerID
            Database.objCommand.Parameters("@CustomerID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPurchaseCustomer"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount > 0 Then proRowIndex = 0

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Purchase / GetRowsByCustomer")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRow()

        Me.CutRow(Me.PurchaseID)

    End Sub

    Friend Sub CutRow(ByVal PurchaseID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = PurchaseID
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPurchase"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Purchase / CutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRowsByCustomer()

        Me.CutRowsByCustomer(Me.CustomerID)

    End Sub

    Friend Sub CutRowsByCustomer(ByVal CustomerID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@CustomerID", SqlDbType.Int).Value = CustomerID
            Database.objCommand.Parameters("@CustomerID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPurchaseCustomer"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Purchase / CutRowsByCustomer")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub SetRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PurchaseID")
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@CustomerID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("CustomerID")
            Database.objCommand.Parameters("@CustomerID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@OrderNumber", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("OrderNumber")
            Database.objCommand.Parameters("@OrderNumber").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@OrderDate", SqlDbType.SmallDateTime).Value = proTable.Rows(proRowIndex)("OrderDate")
            Database.objCommand.Parameters("@OrderDate").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGUPurchase"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Purchase / SetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub PutRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@CustomerID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("CustomerID")
            Database.objCommand.Parameters("@CustomerID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@OrderNumber", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("OrderNumber")
            Database.objCommand.Parameters("@OrderNumber").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@OrderDate", SqlDbType.SmallDateTime).Value = proTable.Rows(proRowIndex)("OrderDate")
            Database.objCommand.Parameters("@OrderDate").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int)
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Output

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGIPurchase"

            Database.objCommand.ExecuteNonQuery

            Me.PurchaseID = CType(Database.objCommand.Parameters("@PurchaseID").Value, System.Int32)

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Purchase / PutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

End Class
