Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Class Payment

    Private proTable As DataTable

    Private proRowCount As System.Int32

    Private proRowIndex As System.Int32

    Private proDBReturn As System.Int32

    Private DBPersistant As System.Boolean

    Private objDataReader As SqlDataReader

    Friend ReadOnly Property Table() As DataTable
        Get
            Return proTable
        End Get
    End Property

    Friend ReadOnly Property Row() As DataRow
        Get
            Return proTable.Rows(proRowIndex)
        End Get
    End Property

    Friend ReadOnly Property XML() As System.String
        Get
            Return Database.XML(proTable)
        End Get
    End Property

    Friend ReadOnly Property RowCount() As System.Int32
        Get
            Return proRowCount
        End Get
    End Property

    Friend ReadOnly Property RowIndex() As System.Int32
        Get
            Return proRowIndex
        End Get
    End Property

    Friend ReadOnly Property DBReturn() As System.Int32
        Get
            Return proDBReturn
        End Get
    End Property

    Friend ReadOnly Property DTNew() As System.DateTime
        Get
            Return Database.DTNew()
        End Get
    End Property

    Friend ReadOnly Property DTNow() As System.DateTime
        Get
            Return Database.DTNow()
        End Get
    End Property

    Friend Property PaymentID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("PaymentID")), Database.Null4(), proTable.Rows(proRowIndex)("PaymentID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("PaymentID") = value
        End Set
    End Property

    Friend Property PurchaseID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("PurchaseID")), Database.Null4(), proTable.Rows(proRowIndex)("PurchaseID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("PurchaseID") = value
        End Set
    End Property

    Friend Property Method() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("Method")), Database.NullS(), proTable.Rows(proRowIndex)("Method")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("Method") = value
        End Set
    End Property

    Friend Property Amount() As System.Decimal
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("Amount")), Database.NullD(), proTable.Rows(proRowIndex)("Amount")), System.Decimal)
        End Get
        Set(ByVal value As System.Decimal)
            proTable.Rows(proRowIndex)("Amount") = value
        End Set
    End Property

    Friend Sub New(ByVal Persistence As System.Boolean)

        DBPersistant = Persistence

        proTable = New DataTable

        proTable.TableName = "Payment"

        proTable.Columns.Add("PaymentID", GetType(System.Int32))
        proTable.Columns.Add("PurchaseID", GetType(System.Int32))
        proTable.Columns.Add("Method", GetType(System.String))
        proTable.Columns.Add("Amount", GetType(System.Decimal))

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear()

        proTable.Rows.Clear()

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear(ByVal Z As System.Int32)

        proTable.Rows.Clear()

        For I As System.Int32 = 1 To Z

            proTable.Rows.Add(proTable.NewRow)

        Next

        proRowCount = Z

        proRowIndex = 0

    End Sub

    Friend Sub Move()

        Me.Move(proRowIndex + 1)

    End Sub

    Friend Sub Move(ByVal MyRow As System.Int32)

        Dim I As System.Int32 = proRowCount - 1

        If MyRow < 0 Then Throw New System.InvalidOperationException("Row Index < 0")

        If MyRow > I Then Throw New System.InvalidOperationException("Row Index > N")

        proRowIndex = MyRow

    End Sub

    Friend Sub ResetColumn(ByVal MyColumn As System.String)

        proTable.Rows(proRowIndex)(MyColumn) = System.DBNull.Value

    End Sub

    Friend Sub GetRow(ByVal PaymentID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PaymentID", SqlDbType.Int).Value = PaymentID
            Database.objCommand.Parameters("@PaymentID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPayment"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount = 1 Then proRowIndex = 0

            If proRowCount < 1 Then Throw New System.InvalidOperationException("Row Count < 1")

            If proRowCount > 1 Then Throw New System.InvalidOperationException("Row Count > 1")

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Payment / GetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub GetRowsByPurchase()

        Me.GetRowsByPurchase(Me.PurchaseID)

    End Sub

    Friend Sub GetRowsByPurchase(ByVal PurchaseID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = PurchaseID
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPaymentPurchase"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount > 0 Then proRowIndex = 0

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Payment / GetRowsByPurchase")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRow()

        Me.CutRow(Me.PaymentID)

    End Sub

    Friend Sub CutRow(ByVal PaymentID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PaymentID", SqlDbType.Int).Value = PaymentID
            Database.objCommand.Parameters("@PaymentID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPayment"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Payment / CutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRowsByPurchase()

        Me.CutRowsByPurchase(Me.PurchaseID)

    End Sub

    Friend Sub CutRowsByPurchase(ByVal PurchaseID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = PurchaseID
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPaymentPurchase"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Payment / CutRowsByPurchase")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub SetRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PaymentID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PaymentID")
            Database.objCommand.Parameters("@PaymentID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PurchaseID")
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Method", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Method")
            Database.objCommand.Parameters("@Method").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Amount", SqlDbType.Decimal).Value = proTable.Rows(proRowIndex)("Amount")
            Database.objCommand.Parameters("@Amount").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGUPayment"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Payment / SetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub PutRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PurchaseID")
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Method", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Method")
            Database.objCommand.Parameters("@Method").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Amount", SqlDbType.Decimal).Value = proTable.Rows(proRowIndex)("Amount")
            Database.objCommand.Parameters("@Amount").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@PaymentID", SqlDbType.Int)
            Database.objCommand.Parameters("@PaymentID").Direction = ParameterDirection.Output

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGIPayment"

            Database.objCommand.ExecuteNonQuery

            Me.PaymentID = CType(Database.objCommand.Parameters("@PaymentID").Value, System.Int32)

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Payment / PutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

End Class
