Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Module Database

    Friend blnSecurity As System.Boolean

    Friend strDBServer As System.String
    Friend strDatabase As System.String
    Friend strUserName As System.String
    Friend strPassword As System.String

    Friend strWinPath As System.String

    Friend strProgram As System.String

    Friend strAccount As System.String

    Friend strConnect As System.String

    Friend objConnect As SqlConnection

    Friend objCommand As SqlCommand

    Friend Sub SaveParameters(ByRef DBParameters() As System.String, ByVal DBSecurity As System.Boolean)

        strDBServer = DBParameters(1)
        strDatabase = DBParameters(2)
        strUserName = DBParameters(3)
        strPassword = DBParameters(4)

        strProgram = DBParameters(5)

        strWinPath = DBParameters(6)

        blnSecurity = DBSecurity

    End Sub

    Friend Sub DBInitialization()

        If blnSecurity = True Then

            strAccount = ";Integrated Security=SSPI"

        Else

            strAccount = ";UID=" & strUserName & ";PWD=" & strPassword

        End If

        Try

            strConnect = "Application Name=" & strProgram & ";Data Source=" & strDBServer & ";Initial Catalog=" & strDatabase & strAccount & ";"

            objConnect = New SqlConnection(strConnect)

            objCommand = New SqlCommand

            objConnect.Open()

            objCommand.Connection = objConnect

            objCommand.CommandTimeout = 30

            objCommand.CommandType = CommandType.Text

        Catch ex As Exception

            RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Database / DBInitialization")

            Throw

        End Try

    End Sub

    Friend Sub CleanTermination()

        Try

            If objCommand IsNot Nothing Then

                objCommand.CommandType = CommandType.Text

                objCommand.CommandText = "WHILE @@TRANCOUNT > 0 ROLLBACK TRANSACTION"

                objCommand.ExecuteNonQuery()

            End If

        Catch ex As Exception

            RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Database / CleanTermination")

        End Try

        Try

            If objConnect IsNot Nothing Then

                If objConnect.State = ConnectionState.Open Then

                    objConnect.Close()

                End If

            End If

            objCommand = Nothing

            objConnect = Nothing

        Catch ex As Exception

            RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Database / CleanTermination")

            Throw

        End Try

    End Sub

    Friend Function XML(ByRef objTable As DataTable) As System.String

        Dim objStringWriter As New StringWriter

        objTable.WriteXml(objStringWriter)

        XML = objStringWriter.ToString

    End Function

    Friend Function Null1() As System.Byte

        Null1 = 0

    End Function

    Friend Function Null2() As System.Int16

        Null2 = 0

    End Function

    Friend Function Null4() As System.Int32

        Null4 = 0

    End Function

    Friend Function Null8() As System.Int64

        Null8 = 0

    End Function

    Friend Function NullR() As System.Single

        NullR = 0

    End Function

    Friend Function NullF() As System.Double

        NullF = 0

    End Function

    Friend Function NullD() As System.Decimal

        NullD = 0

    End Function

    Friend Function NullB() As System.Boolean

        NullB = False

    End Function

    Friend Function NullS() As System.String

        NullS = System.String.Empty

    End Function

    Friend Function NullG() As System.Guid

        NullG = System.Guid.Empty

    End Function

    Friend Function NullO() As System.Byte()

        NullO = New System.Byte() {}

    End Function

    Friend Function DTNew() As System.DateTime

        DTNew = Convert.ToDateTime("1900/01/01")

    End Function

    Friend Function DTNow() As System.DateTime

        DTNow = System.DateTime.Now

    End Function

    Friend Function FormatDate(ByVal MyDateTime As System.DateTime) As System.String

        FormatDate = MyDateTime.ToString("yyyy/MM/dd")

    End Function

    Friend Function FormatTime(ByVal MyDateTime As System.DateTime) As System.String

        FormatTime = MyDateTime.ToString("HH:mm:ss")

    End Function

    Friend Sub RecordMessage(ByVal MyShort1 As System.String, ByVal MyShort2 As System.String, ByVal MyLong1 As System.String, ByVal MyLong2 As System.String)

        Dim objFS As FileStream

        Dim objFW As StreamWriter

        Dim objDT As System.DateTime = DTNow()

        Dim WinPath As System.String = Path.Combine(strWinPath, "Errors.log")

        objFS = New FileStream(WinPath, FileMode.Append, FileAccess.Write)

        objFW = New StreamWriter(objFS)

        objFW.WriteLine("The following error occurred on " & FormatDate(objDT) & " at " & FormatTime(objDT))

        'objFW.WriteLine(MyShort2)
        'objFW.WriteLine(MyShort1)
        objFW.WriteLine(MyLong2)
        objFW.WriteLine(MyLong1)

        objFW.WriteLine(System.String.Empty)

        objFW.Close() : objFW = Nothing

        objFS.Close() : objFS = Nothing

    End Sub

End Module
