Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Class Shipment

    Private proTable As DataTable

    Private proRowCount As System.Int32

    Private proRowIndex As System.Int32

    Private proDBReturn As System.Int32

    Private DBPersistant As System.Boolean

    Private objDataReader As SqlDataReader

    Friend ReadOnly Property Table() As DataTable
        Get
            Return proTable
        End Get
    End Property

    Friend ReadOnly Property Row() As DataRow
        Get
            Return proTable.Rows(proRowIndex)
        End Get
    End Property

    Friend ReadOnly Property XML() As System.String
        Get
            Return Database.XML(proTable)
        End Get
    End Property

    Friend ReadOnly Property RowCount() As System.Int32
        Get
            Return proRowCount
        End Get
    End Property

    Friend ReadOnly Property RowIndex() As System.Int32
        Get
            Return proRowIndex
        End Get
    End Property

    Friend ReadOnly Property DBReturn() As System.Int32
        Get
            Return proDBReturn
        End Get
    End Property

    Friend ReadOnly Property DTNew() As System.DateTime
        Get
            Return Database.DTNew()
        End Get
    End Property

    Friend ReadOnly Property DTNow() As System.DateTime
        Get
            Return Database.DTNow()
        End Get
    End Property

    Friend Property ShipmentID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("ShipmentID")), Database.Null4(), proTable.Rows(proRowIndex)("ShipmentID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("ShipmentID") = value
        End Set
    End Property

    Friend Property Carrier() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("Carrier")), Database.NullS(), proTable.Rows(proRowIndex)("Carrier")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("Carrier") = value
        End Set
    End Property

    Friend Property TrackingNumber() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("TrackingNumber")), Database.NullS(), proTable.Rows(proRowIndex)("TrackingNumber")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("TrackingNumber") = value
        End Set
    End Property

    Friend Property ShipDate() As System.DateTime
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("ShipDate")), Database.DTNew(), proTable.Rows(proRowIndex)("ShipDate")), System.DateTime)
        End Get
        Set(ByVal value As System.DateTime)
            proTable.Rows(proRowIndex)("ShipDate") = value
        End Set
    End Property

    Friend Sub New(ByVal Persistence As System.Boolean)

        DBPersistant = Persistence

        proTable = New DataTable

        proTable.TableName = "Shipment"

        proTable.Columns.Add("ShipmentID", GetType(System.Int32))
        proTable.Columns.Add("Carrier", GetType(System.String))
        proTable.Columns.Add("TrackingNumber", GetType(System.String))
        proTable.Columns.Add("ShipDate", GetType(System.DateTime))

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear()

        proTable.Rows.Clear()

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear(ByVal Z As System.Int32)

        proTable.Rows.Clear()

        For I As System.Int32 = 1 To Z

            proTable.Rows.Add(proTable.NewRow)

        Next

        proRowCount = Z

        proRowIndex = 0

    End Sub

    Friend Sub Move()

        Me.Move(proRowIndex + 1)

    End Sub

    Friend Sub Move(ByVal MyRow As System.Int32)

        Dim I As System.Int32 = proRowCount - 1

        If MyRow < 0 Then Throw New System.InvalidOperationException("Row Index < 0")

        If MyRow > I Then Throw New System.InvalidOperationException("Row Index > N")

        proRowIndex = MyRow

    End Sub

    Friend Sub ResetColumn(ByVal MyColumn As System.String)

        proTable.Rows(proRowIndex)(MyColumn) = System.DBNull.Value

    End Sub

    Friend Sub GetRow(ByVal ShipmentID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ShipmentID", SqlDbType.Int).Value = ShipmentID
            Database.objCommand.Parameters("@ShipmentID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSShipment"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount = 1 Then proRowIndex = 0

            If proRowCount < 1 Then Throw New System.InvalidOperationException("Row Count < 1")

            If proRowCount > 1 Then Throw New System.InvalidOperationException("Row Count > 1")

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Shipment / GetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRow()

        Me.CutRow(Me.ShipmentID)

    End Sub

    Friend Sub CutRow(ByVal ShipmentID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ShipmentID", SqlDbType.Int).Value = ShipmentID
            Database.objCommand.Parameters("@ShipmentID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDShipment"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Shipment / CutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub SetRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ShipmentID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("ShipmentID")
            Database.objCommand.Parameters("@ShipmentID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Carrier", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Carrier")
            Database.objCommand.Parameters("@Carrier").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@TrackingNumber", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("TrackingNumber")
            Database.objCommand.Parameters("@TrackingNumber").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@ShipDate", SqlDbType.SmallDateTime).Value = proTable.Rows(proRowIndex)("ShipDate")
            Database.objCommand.Parameters("@ShipDate").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGUShipment"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Shipment / SetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub PutRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@Carrier", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Carrier")
            Database.objCommand.Parameters("@Carrier").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@TrackingNumber", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("TrackingNumber")
            Database.objCommand.Parameters("@TrackingNumber").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@ShipDate", SqlDbType.SmallDateTime).Value = proTable.Rows(proRowIndex)("ShipDate")
            Database.objCommand.Parameters("@ShipDate").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@ShipmentID", SqlDbType.Int)
            Database.objCommand.Parameters("@ShipmentID").Direction = ParameterDirection.Output

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGIShipment"

            Database.objCommand.ExecuteNonQuery

            Me.ShipmentID = CType(Database.objCommand.Parameters("@ShipmentID").Value, System.Int32)

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Shipment / PutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

End Class
