Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Class PurchaseItem

    Private proTable As DataTable

    Private proRowCount As System.Int32

    Private proRowIndex As System.Int32

    Private proDBReturn As System.Int32

    Private DBPersistant As System.Boolean

    Private objDataReader As SqlDataReader

    Friend ReadOnly Property Table() As DataTable
        Get
            Return proTable
        End Get
    End Property

    Friend ReadOnly Property Row() As DataRow
        Get
            Return proTable.Rows(proRowIndex)
        End Get
    End Property

    Friend ReadOnly Property XML() As System.String
        Get
            Return Database.XML(proTable)
        End Get
    End Property

    Friend ReadOnly Property RowCount() As System.Int32
        Get
            Return proRowCount
        End Get
    End Property

    Friend ReadOnly Property RowIndex() As System.Int32
        Get
            Return proRowIndex
        End Get
    End Property

    Friend ReadOnly Property DBReturn() As System.Int32
        Get
            Return proDBReturn
        End Get
    End Property

    Friend ReadOnly Property DTNew() As System.DateTime
        Get
            Return Database.DTNew()
        End Get
    End Property

    Friend ReadOnly Property DTNow() As System.DateTime
        Get
            Return Database.DTNow()
        End Get
    End Property

    Friend Property PurchaseItemID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("PurchaseItemID")), Database.Null4(), proTable.Rows(proRowIndex)("PurchaseItemID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("PurchaseItemID") = value
        End Set
    End Property

    Friend Property PurchaseID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("PurchaseID")), Database.Null4(), proTable.Rows(proRowIndex)("PurchaseID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("PurchaseID") = value
        End Set
    End Property

    Friend Property ProductID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("ProductID")), Database.Null4(), proTable.Rows(proRowIndex)("ProductID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("ProductID") = value
        End Set
    End Property

    Friend Property Quantity() As System.Int16
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("Quantity")), Database.Null2(), proTable.Rows(proRowIndex)("Quantity")), System.Int16)
        End Get
        Set(ByVal value As System.Int16)
            proTable.Rows(proRowIndex)("Quantity") = value
        End Set
    End Property

    Friend Property LineNumber() As System.Int16
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("LineNumber")), Database.Null2(), proTable.Rows(proRowIndex)("LineNumber")), System.Int16)
        End Get
        Set(ByVal value As System.Int16)
            proTable.Rows(proRowIndex)("LineNumber") = value
        End Set
    End Property

    Friend Sub New(ByVal Persistence As System.Boolean)

        DBPersistant = Persistence

        proTable = New DataTable

        proTable.TableName = "PurchaseItem"

        proTable.Columns.Add("PurchaseItemID", GetType(System.Int32))
        proTable.Columns.Add("PurchaseID", GetType(System.Int32))
        proTable.Columns.Add("ProductID", GetType(System.Int32))
        proTable.Columns.Add("Quantity", GetType(System.Int16))
        proTable.Columns.Add("LineNumber", GetType(System.Int16))

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear()

        proTable.Rows.Clear()

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear(ByVal Z As System.Int32)

        proTable.Rows.Clear()

        For I As System.Int32 = 1 To Z

            proTable.Rows.Add(proTable.NewRow)

        Next

        proRowCount = Z

        proRowIndex = 0

    End Sub

    Friend Sub Move()

        Me.Move(proRowIndex + 1)

    End Sub

    Friend Sub Move(ByVal MyRow As System.Int32)

        Dim I As System.Int32 = proRowCount - 1

        If MyRow < 0 Then Throw New System.InvalidOperationException("Row Index < 0")

        If MyRow > I Then Throw New System.InvalidOperationException("Row Index > N")

        proRowIndex = MyRow

    End Sub

    Friend Sub ResetColumn(ByVal MyColumn As System.String)

        proTable.Rows(proRowIndex)(MyColumn) = System.DBNull.Value

    End Sub

    Friend Sub GetRow(ByVal PurchaseItemID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseItemID", SqlDbType.Int).Value = PurchaseItemID
            Database.objCommand.Parameters("@PurchaseItemID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPurchaseItem"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount = 1 Then proRowIndex = 0

            If proRowCount < 1 Then Throw New System.InvalidOperationException("Row Count < 1")

            If proRowCount > 1 Then Throw New System.InvalidOperationException("Row Count > 1")

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / GetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub GetRowsByProduct()

        Me.GetRowsByProduct(Me.ProductID)

    End Sub

    Friend Sub GetRowsByProduct(ByVal ProductID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = ProductID
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPurchaseItemProduct"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount > 0 Then proRowIndex = 0

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / GetRowsByProduct")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub GetRowsByPurchase()

        Me.GetRowsByPurchase(Me.PurchaseID)

    End Sub

    Friend Sub GetRowsByPurchase(ByVal PurchaseID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = PurchaseID
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSPurchaseItemPurchase"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount > 0 Then proRowIndex = 0

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / GetRowsByPurchase")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRow()

        Me.CutRow(Me.PurchaseItemID)

    End Sub

    Friend Sub CutRow(ByVal PurchaseItemID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseItemID", SqlDbType.Int).Value = PurchaseItemID
            Database.objCommand.Parameters("@PurchaseItemID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPurchaseItem"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / CutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRowsByProduct()

        Me.CutRowsByProduct(Me.ProductID)

    End Sub

    Friend Sub CutRowsByProduct(ByVal ProductID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = ProductID
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPurchaseItemProduct"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / CutRowsByProduct")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRowsByPurchase()

        Me.CutRowsByPurchase(Me.PurchaseID)

    End Sub

    Friend Sub CutRowsByPurchase(ByVal PurchaseID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = PurchaseID
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDPurchaseItemPurchase"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / CutRowsByPurchase")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub SetRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseItemID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PurchaseItemID")
            Database.objCommand.Parameters("@PurchaseItemID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PurchaseID")
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("ProductID")
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Quantity", SqlDbType.SmallInt).Value = proTable.Rows(proRowIndex)("Quantity")
            Database.objCommand.Parameters("@Quantity").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@LineNumber", SqlDbType.SmallInt).Value = proTable.Rows(proRowIndex)("LineNumber")
            Database.objCommand.Parameters("@LineNumber").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGUPurchaseItem"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / SetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub PutRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@PurchaseID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("PurchaseID")
            Database.objCommand.Parameters("@PurchaseID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("ProductID")
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Quantity", SqlDbType.SmallInt).Value = proTable.Rows(proRowIndex)("Quantity")
            Database.objCommand.Parameters("@Quantity").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@LineNumber", SqlDbType.SmallInt).Value = proTable.Rows(proRowIndex)("LineNumber")
            Database.objCommand.Parameters("@LineNumber").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@PurchaseItemID", SqlDbType.Int)
            Database.objCommand.Parameters("@PurchaseItemID").Direction = ParameterDirection.Output

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGIPurchaseItem"

            Database.objCommand.ExecuteNonQuery

            Me.PurchaseItemID = CType(Database.objCommand.Parameters("@PurchaseItemID").Value, System.Int32)

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "PurchaseItem / PutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

End Class
