Imports System

Imports System.IO
Imports System.Net
Imports System.Text

Imports System.Data
Imports System.Data.SqlClient

Imports System.Collections
Imports System.Collections.Generic

Imports System.Diagnostics

Friend Class Product

    Private proTable As DataTable

    Private proRowCount As System.Int32

    Private proRowIndex As System.Int32

    Private proDBReturn As System.Int32

    Private DBPersistant As System.Boolean

    Private objDataReader As SqlDataReader

    Friend ReadOnly Property Table() As DataTable
        Get
            Return proTable
        End Get
    End Property

    Friend ReadOnly Property Row() As DataRow
        Get
            Return proTable.Rows(proRowIndex)
        End Get
    End Property

    Friend ReadOnly Property XML() As System.String
        Get
            Return Database.XML(proTable)
        End Get
    End Property

    Friend ReadOnly Property RowCount() As System.Int32
        Get
            Return proRowCount
        End Get
    End Property

    Friend ReadOnly Property RowIndex() As System.Int32
        Get
            Return proRowIndex
        End Get
    End Property

    Friend ReadOnly Property DBReturn() As System.Int32
        Get
            Return proDBReturn
        End Get
    End Property

    Friend ReadOnly Property DTNew() As System.DateTime
        Get
            Return Database.DTNew()
        End Get
    End Property

    Friend ReadOnly Property DTNow() As System.DateTime
        Get
            Return Database.DTNow()
        End Get
    End Property

    Friend Property ProductID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("ProductID")), Database.Null4(), proTable.Rows(proRowIndex)("ProductID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("ProductID") = value
        End Set
    End Property

    Friend Property VendorID() As System.Int32
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("VendorID")), Database.Null4(), proTable.Rows(proRowIndex)("VendorID")), System.Int32)
        End Get
        Set(ByVal value As System.Int32)
            proTable.Rows(proRowIndex)("VendorID") = value
        End Set
    End Property

    Friend Property Description() As System.String
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("Description")), Database.NullS(), proTable.Rows(proRowIndex)("Description")), System.String)
        End Get
        Set(ByVal value As System.String)
            proTable.Rows(proRowIndex)("Description") = value
        End Set
    End Property

    Friend Property WholesaleCost() As System.Decimal
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("WholesaleCost")), Database.NullD(), proTable.Rows(proRowIndex)("WholesaleCost")), System.Decimal)
        End Get
        Set(ByVal value As System.Decimal)
            proTable.Rows(proRowIndex)("WholesaleCost") = value
        End Set
    End Property

    Friend Property RetailPrice() As System.Decimal
        Get
            Return CType(IIf(Convert.IsDBNull(proTable.Rows(proRowIndex)("RetailPrice")), Database.NullD(), proTable.Rows(proRowIndex)("RetailPrice")), System.Decimal)
        End Get
        Set(ByVal value As System.Decimal)
            proTable.Rows(proRowIndex)("RetailPrice") = value
        End Set
    End Property

    Friend Sub New(ByVal Persistence As System.Boolean)

        DBPersistant = Persistence

        proTable = New DataTable

        proTable.TableName = "Product"

        proTable.Columns.Add("ProductID", GetType(System.Int32))
        proTable.Columns.Add("VendorID", GetType(System.Int32))
        proTable.Columns.Add("Description", GetType(System.String))
        proTable.Columns.Add("WholesaleCost", GetType(System.Decimal))
        proTable.Columns.Add("RetailPrice", GetType(System.Decimal))

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear()

        proTable.Rows.Clear()

        proRowCount = 0

        proRowIndex = -1

    End Sub

    Friend Sub Clear(ByVal Z As System.Int32)

        proTable.Rows.Clear()

        For I As System.Int32 = 1 To Z

            proTable.Rows.Add(proTable.NewRow)

        Next

        proRowCount = Z

        proRowIndex = 0

    End Sub

    Friend Sub Move()

        Me.Move(proRowIndex + 1)

    End Sub

    Friend Sub Move(ByVal MyRow As System.Int32)

        Dim I As System.Int32 = proRowCount - 1

        If MyRow < 0 Then Throw New System.InvalidOperationException("Row Index < 0")

        If MyRow > I Then Throw New System.InvalidOperationException("Row Index > N")

        proRowIndex = MyRow

    End Sub

    Friend Sub ResetColumn(ByVal MyColumn As System.String)

        proTable.Rows(proRowIndex)(MyColumn) = System.DBNull.Value

    End Sub

    Friend Sub GetRow(ByVal ProductID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = ProductID
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSProduct"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount = 1 Then proRowIndex = 0

            If proRowCount < 1 Then Throw New System.InvalidOperationException("Row Count < 1")

            If proRowCount > 1 Then Throw New System.InvalidOperationException("Row Count > 1")

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Product / GetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub GetRowsByVendor()

        Me.GetRowsByVendor(Me.VendorID)

    End Sub

    Friend Sub GetRowsByVendor(ByVal VendorID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@VendorID", SqlDbType.Int).Value = VendorID
            Database.objCommand.Parameters("@VendorID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGSProductVendor"

            objDataReader = Database.objCommand.ExecuteReader()

            proTable.Rows.Clear()

            proTable.Load(objDataReader)

            If objDataReader.IsClosed = False Then objDataReader.Close()

            objDataReader = Nothing

            proRowCount = proTable.Rows.Count

            proRowIndex = -1

            If proRowCount > 0 Then proRowIndex = 0

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Product / GetRowsByVendor")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRow()

        Me.CutRow(Me.ProductID)

    End Sub

    Friend Sub CutRow(ByVal ProductID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = ProductID
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDProduct"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Product / CutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub CutRowsByVendor()

        Me.CutRowsByVendor(Me.VendorID)

    End Sub

    Friend Sub CutRowsByVendor(ByVal VendorID As System.Int32)

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@VendorID", SqlDbType.Int).Value = VendorID
            Database.objCommand.Parameters("@VendorID").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGDProductVendor"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Product / CutRowsByVendor")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub SetRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("ProductID")
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@VendorID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("VendorID")
            Database.objCommand.Parameters("@VendorID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Description", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Description")
            Database.objCommand.Parameters("@Description").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@WholesaleCost", SqlDbType.Decimal).Value = proTable.Rows(proRowIndex)("WholesaleCost")
            Database.objCommand.Parameters("@WholesaleCost").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@RetailPrice", SqlDbType.Decimal).Value = proTable.Rows(proRowIndex)("RetailPrice")
            Database.objCommand.Parameters("@RetailPrice").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGUProduct"

            Database.objCommand.ExecuteNonQuery

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Product / SetRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

    Friend Sub PutRow()

        proDBReturn = 0

        Try

            If DBPersistant = False Then Database.DBInitialization()

            Database.objCommand.Parameters.Clear()

            Database.objCommand.Parameters.Add("@VendorID", SqlDbType.Int).Value = proTable.Rows(proRowIndex)("VendorID")
            Database.objCommand.Parameters("@VendorID").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@Description", SqlDbType.VarChar).Value = proTable.Rows(proRowIndex)("Description")
            Database.objCommand.Parameters("@Description").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@WholesaleCost", SqlDbType.Decimal).Value = proTable.Rows(proRowIndex)("WholesaleCost")
            Database.objCommand.Parameters("@WholesaleCost").Direction = ParameterDirection.Input
            Database.objCommand.Parameters.Add("@RetailPrice", SqlDbType.Decimal).Value = proTable.Rows(proRowIndex)("RetailPrice")
            Database.objCommand.Parameters("@RetailPrice").Direction = ParameterDirection.Input

            Database.objCommand.Parameters.Add("@ProductID", SqlDbType.Int)
            Database.objCommand.Parameters("@ProductID").Direction = ParameterDirection.Output

            Database.objCommand.Parameters.Add("@RETURN", SqlDbType.Int)
            Database.objCommand.Parameters("@RETURN").Direction = ParameterDirection.ReturnValue

            Database.objCommand.CommandType = CommandType.StoredProcedure

            Database.objCommand.CommandText = "dbo.uspGIProduct"

            Database.objCommand.ExecuteNonQuery

            Me.ProductID = CType(Database.objCommand.Parameters("@ProductID").Value, System.Int32)

            proDBReturn = Convert.ToInt32(Database.objCommand.Parameters("@RETURN").Value)

            If proDBReturn <> 0 Then

                Throw New System.InvalidOperationException("SQL Server Error " & Convert.ToString(DBReturn))

            End If

        Catch ex As Exception

            Database.RecordMessage(ex.Source, ex.TargetSite.Name, ex.Message, "Product / PutRow")

            Throw

        Finally

            If DBPersistant = False Then Database.CleanTermination()

        End Try

    End Sub

End Class
