-- Create a couple custom SQL Routines for DBGizmo to examine
 
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'qryOrders') DROP VIEW dbo.qryOrders
GO
CREATE VIEW dbo.qryOrders
AS
   SELECT O.CustomerID
        , O.OrderNumber
        , O.OrderDate
        , I.LineNumber
        , I.Quantity
        , P.Description
        , P.RetailPrice
     FROM   Purchase     AS O
     JOIN   PurchaseItem AS I
       ON O.PurchaseID
        = I.PurchaseID
     JOIN   Product      AS P
       ON I.ProductID
        = P.ProductID
GO
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'uspCustomerOrders') DROP PROCEDURE dbo.uspCustomerOrders
GO
CREATE PROCEDURE dbo.uspCustomerOrders
       @CustomerID int
AS
   SELECT R.RegionCode
        , R.RegionName
        , C.Name
        , C.Address
        , C.Phone
        , O.OrderNumber
        , O.OrderDate
        , O.LineNumber
        , O.Quantity
        , O.Description
        , O.RetailPrice
     FROM   Customer  AS C
     JOIN   Region    AS R
       ON C.RegionID
        = R.RegionID
     JOIN   qryOrders AS O
       ON C.CustomerID
        = O.CustomerID
    WHERE C.CustomerID
        =  @CustomerID
RETURN (@@ERROR)
GO
