-- Generated by DBGizmo on 2009/01/01 at 00:00:00

-- Table Definitions ...

   CREATE TABLE dbo.Region
        ( RegionID                  int NOT NULL IDENTITY(1,1)
        , RegionCode         char(0002) NOT NULL
        , RegionName      varchar(0040) NOT NULL
        , Representative  varchar(0040) NOT NULL )

   CREATE TABLE dbo.Shipment
        ( ShipmentID                int NOT NULL IDENTITY(1,1)
        , Carrier         varchar(0020) NOT NULL
        , TrackingNumber  varchar(0020) NOT NULL
        , ShipDate        smalldatetime NOT NULL )

   CREATE TABLE dbo.Vendor
        ( VendorID            int NOT NULL IDENTITY(1,1)
        , Name      varchar(0080) NOT NULL
        , Address   varchar(0080) NOT NULL
        , Phone     varchar(0020) NOT NULL )

   CREATE TABLE dbo.Customer
        ( CustomerID            int NOT NULL IDENTITY(1,1)
        , RegionID              int NOT NULL
        , Name        varchar(0080) NOT NULL
        , Address     varchar(0080) NOT NULL
        , Phone       varchar(0020) NOT NULL )

   CREATE TABLE dbo.Product
        ( ProductID                 int NOT NULL IDENTITY(1,1)
        , VendorID                  int NOT NULL
        , Description     varchar(0080) NOT NULL
        , WholesaleCost  decimal(07,02) NOT NULL
        , RetailPrice    decimal(07,02) NOT NULL )

   CREATE TABLE dbo.Purchase
        ( PurchaseID             int NOT NULL IDENTITY(1,1)
        , CustomerID             int NOT NULL
        , OrderNumber            int NOT NULL
        , OrderDate    smalldatetime NOT NULL )

   CREATE TABLE dbo.Payment
        ( PaymentID              int NOT NULL IDENTITY(1,1)
        , PurchaseID             int NOT NULL
        , Method       varchar(0020) NOT NULL
        , Amount      decimal(07,02) NOT NULL )

   CREATE TABLE dbo.PurchaseItem
        ( PurchaseItemID       int NOT NULL IDENTITY(1,1)
        , PurchaseID           int NOT NULL
        , ProductID            int NOT NULL
        , Quantity        smallint NOT NULL
        , LineNumber      smallint NOT NULL )

   CREATE TABLE dbo.PurchaseItemShipment
        ( PurchaseItemShipmentID  int NOT NULL IDENTITY(1,1)
        , PurchaseItemID          int NOT NULL
        , ShipmentID              int NOT NULL )

-- Check Constraints ...

-- Primary Keys ...

ALTER TABLE dbo.Region ADD CONSTRAINT keyPKRegion PRIMARY KEY CLUSTERED (RegionID)

ALTER TABLE dbo.Shipment ADD CONSTRAINT keyPKShipment PRIMARY KEY CLUSTERED (ShipmentID)

ALTER TABLE dbo.Vendor ADD CONSTRAINT keyPKVendor PRIMARY KEY CLUSTERED (VendorID)

ALTER TABLE dbo.Customer ADD CONSTRAINT keyPKCustomer PRIMARY KEY CLUSTERED (CustomerID)

ALTER TABLE dbo.Product ADD CONSTRAINT keyPKProduct PRIMARY KEY CLUSTERED (ProductID)

ALTER TABLE dbo.Purchase ADD CONSTRAINT keyPKPurchase PRIMARY KEY CLUSTERED (PurchaseID)

ALTER TABLE dbo.Payment ADD CONSTRAINT keyPKPayment PRIMARY KEY CLUSTERED (PaymentID)

ALTER TABLE dbo.PurchaseItem ADD CONSTRAINT keyPKPurchaseItem PRIMARY KEY CLUSTERED (PurchaseItemID)

ALTER TABLE dbo.PurchaseItemShipment ADD CONSTRAINT keyPKPurchaseItemShipment PRIMARY KEY CLUSTERED (PurchaseItemShipmentID)

-- Another Keys ...

-- Foreign Keys ...

ALTER TABLE dbo.Customer ADD CONSTRAINT keyFKCustomerRegion FOREIGN KEY (RegionID) REFERENCES dbo.Region (RegionID)

ALTER TABLE dbo.Product ADD CONSTRAINT keyFKProductVendor FOREIGN KEY (VendorID) REFERENCES dbo.Vendor (VendorID)

ALTER TABLE dbo.Purchase ADD CONSTRAINT keyFKPurchaseCustomer FOREIGN KEY (CustomerID) REFERENCES dbo.Customer (CustomerID)

ALTER TABLE dbo.Payment ADD CONSTRAINT keyFKPaymentPurchase FOREIGN KEY (PurchaseID) REFERENCES dbo.Purchase (PurchaseID)

ALTER TABLE dbo.PurchaseItem ADD CONSTRAINT keyFKPurchaseItemProduct FOREIGN KEY (ProductID) REFERENCES dbo.Product (ProductID)
ALTER TABLE dbo.PurchaseItem ADD CONSTRAINT keyFKPurchaseItemPurchase FOREIGN KEY (PurchaseID) REFERENCES dbo.Purchase (PurchaseID)

ALTER TABLE dbo.PurchaseItemShipment ADD CONSTRAINT keyFKPurchaseItemShipmentPurchaseItem FOREIGN KEY (PurchaseItemID) REFERENCES dbo.PurchaseItem (PurchaseItemID)
ALTER TABLE dbo.PurchaseItemShipment ADD CONSTRAINT keyFKPurchaseItemShipmentShipment FOREIGN KEY (ShipmentID) REFERENCES dbo.Shipment (ShipmentID)

-- Foreign Key Indexes ...

CREATE NONCLUSTERED INDEX idxRegion ON dbo.Customer (RegionID)

CREATE NONCLUSTERED INDEX idxVendor ON dbo.Product (VendorID)

CREATE NONCLUSTERED INDEX idxCustomer ON dbo.Purchase (CustomerID)

CREATE NONCLUSTERED INDEX idxPurchase ON dbo.Payment (PurchaseID)

CREATE NONCLUSTERED INDEX idxProduct ON dbo.PurchaseItem (ProductID)
CREATE NONCLUSTERED INDEX idxPurchase ON dbo.PurchaseItem (PurchaseID)

CREATE NONCLUSTERED INDEX idxPurchaseItem ON dbo.PurchaseItemShipment (PurchaseItemID)
CREATE NONCLUSTERED INDEX idxShipment ON dbo.PurchaseItemShipment (ShipmentID)

-- Performance Indexes ...

-- Permissions ...

