-- Generated by DBGizmo on 2009/01/01 at 00:00:00

-- dbo.Customer

CREATE TABLE AUDIT.dbo.Customer
     ( AuditRowID           bigint IDENTITY(1,1)
     , AuditRowUser  varchar(0040)
     , AuditRowHost  varchar(0040)
     , AuditRowDate       datetime
     , CustomerID              int
     , RegionID                int
     , Name          varchar(0080)
     , Address       varchar(0080)
     , Phone         varchar(0020) )
GO
ALTER TABLE AUDIT.dbo.Customer ADD CONSTRAINT keyPKCustomer PRIMARY KEY CLUSTERED (AuditRowID)
GO
--: CREATE TRIGGER dbo.trgAICustomer ON dbo.Customer
--: FOR INSERT
--: AS
--: BEGIN
--: SET NOCOUNT ON
--: INSERT AUDIT.dbo.Customer
--:      ( AuditRowUser
--:      , AuditRowHost
--:      , AuditRowDate
--:      , CustomerID
--:      , RegionID
--:      , Name
--:      , Address
--:      , Phone )
--: SELECT LEFT(SYSTEM_USER,0040)
--:      , LEFT(HOST_NAME(),0040)
--:      , GETDATE()
--:      , CustomerID
--:      , RegionID
--:      , Name
--:      , Address
--:      , Phone
--:   FROM Inserted
--: SET NOCOUNT OFF
--: END
GO
CREATE TRIGGER dbo.trgAUCustomer ON dbo.Customer
FOR UPDATE
AS
BEGIN
SET NOCOUNT ON
DECLARE @T smallint
DECLARE @I smallint
SET @T = 0
SET @I = 0
WHILE @T = 0 AND @I < 5
BEGIN
SET @T = SUBSTRING(COLUMNS_UPDATED(),(@I/8)+1,1) & POWER(2,(@I%8))
SET @I = @I + 1
IF  @I =    0 SET @T = 0 -- Create Date, Column ID
IF  @I =    0 SET @T = 0 -- Modify Date, Column ID
END
IF @T != 0
INSERT AUDIT.dbo.Customer
     ( AuditRowUser
     , AuditRowHost
     , AuditRowDate
     , CustomerID
     , RegionID
     , Name
     , Address
     , Phone )
SELECT LEFT(SYSTEM_USER,0040)
     , LEFT(HOST_NAME(),0040)
     , GETDATE()
     , CustomerID
     , RegionID
     , Name
     , Address
     , Phone
  FROM Deleted 
SET NOCOUNT OFF
END
GO
CREATE TRIGGER dbo.trgADCustomer ON dbo.Customer
FOR DELETE
AS
BEGIN
SET NOCOUNT ON
INSERT AUDIT.dbo.Customer
     ( AuditRowUser
     , AuditRowHost
     , AuditRowDate
     , CustomerID
     , RegionID
     , Name
     , Address
     , Phone )
SELECT LEFT(SYSTEM_USER,0040)
     , LEFT(HOST_NAME(),0040)
     , GETDATE()
     , CustomerID
     , RegionID
     , Name
     , Address
     , Phone
  FROM Deleted 
SET NOCOUNT OFF
END
GO

